<?php

class ControllerModuleNetgsm extends Controller
{
    private $error = array();

    public function index()
    {
//        $this->load->language('extension/module/account');

        $this->document->setTitle("Netgsm SMS");

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('netgsm', $this->request->post);

            $this->session->data['success'] = 'Başarılı: Netgsm SMS modülü güncellendi!';
            if(isset($this->request->post['sayfayi_yenile']) and $this->request->post['sayfayi_yenile'] ){
                $this->redirect($this->url->link('module/netgsm','token=' . $this->session->data['token'], 'SSL'));
            }else{
                $this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
            }
        }

        $this->data['button_save'] = $this->language->get('button_save');
        $this->data['button_cancel'] = $this->language->get('button_cancel');

        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }

        $this->data['breadcrumbs'] = array();

        $this->data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => false
        );

        $this->data['breadcrumbs'][] = array(
            'text' => "Eklentiler",
            'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );

        $this->data['breadcrumbs'][] = array(
            'text' => "Netgsm SMS",
            'href' => $this->url->link('module/netgsm', 'token=' . $this->session->data['token'], 'SSL'),
            'separator' => ' :: '
        );

        $this->data['action'] = $this->url->link('module/netgsm', 'token=' . $this->session->data['token'], 'SSL');

        $this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');

        if (isset($this->request->post['netgsm_status'])) {
            $this->data['netgsm_status'] = $this->request->post['netgsm_status'];
        } else {
            $this->data['netgsm_status'] = $this->config->get('netgsm_status');
        }
        if (isset($this->request->post['netgsm_usercode'])) {
            $this->data['netgsm_usercode'] = $this->request->post['netgsm_usercode'];
        } else {
            $this->data['netgsm_usercode'] = $this->config->get('netgsm_usercode');
        }
        if (isset($this->request->post['netgsm_password'])) {
            $this->data['netgsm_password'] = $this->request->post['netgsm_password'];
        } else {
            $this->data['netgsm_password'] = $this->config->get('netgsm_password');
        }
        if (isset($this->request->post['netgsm_uyelik_bildirimi'])) {
            $this->data['netgsm_uyelik_bildirimi'] = $this->request->post['netgsm_uyelik_bildirimi'];
        } else {
            $this->data['netgsm_uyelik_bildirimi'] = $this->config->get('netgsm_uyelik_bildirimi');
        }
        if (isset($this->request->post['netgsm_uyelik_bildirimi_metni'])) {
            $this->data['netgsm_uyelik_bildirimi_metni'] = $this->request->post['netgsm_uyelik_bildirimi_metni'];
        } else {
            $this->data['netgsm_uyelik_bildirimi_metni'] = $this->config->get('netgsm_uyelik_bildirimi_metni');
        }
        if (isset($this->request->post['netgsm_uyelik_bildirimi_yonetici'])) {
            $this->data['netgsm_uyelik_bildirimi_yonetici'] = $this->request->post['netgsm_uyelik_bildirimi_yonetici'];
        } else {
            $this->data['netgsm_uyelik_bildirimi_yonetici'] = $this->config->get('netgsm_uyelik_bildirimi_yonetici');
        }
        if (isset($this->request->post['netgsm_uyelik_bildirimi_yonetici_metni'])) {
            $this->data['netgsm_uyelik_bildirimi_yonetici_metni'] = $this->request->post['netgsm_uyelik_bildirimi_yonetici_metni'];
        } else {
            $this->data['netgsm_uyelik_bildirimi_yonetici_metni'] = $this->config->get('netgsm_uyelik_bildirimi_yonetici_metni');
        }
        if (isset($this->request->post['netgsm_uyelik_bildirim_numaralari'])) {
            $this->data['netgsm_uyelik_bildirim_numaralari'] = $this->request->post['netgsm_uyelik_bildirim_numaralari'];
        } else {
            $this->data['netgsm_uyelik_bildirim_numaralari'] = $this->config->get('netgsm_uyelik_bildirim_numaralari');
        }
        if (isset($this->request->post['netgsm_yeni_siparis_bildirimi'])) {
            $this->data['netgsm_yeni_siparis_bildirimi'] = $this->request->post['netgsm_yeni_siparis_bildirimi'];
        } else {
            $this->data['netgsm_yeni_siparis_bildirimi'] = $this->config->get('netgsm_yeni_siparis_bildirimi');
        }
        if (isset($this->request->post['netgsm_yeni_siparis_bildirimi_metni'])) {
            $this->data['netgsm_yeni_siparis_bildirimi_metni'] = $this->request->post['netgsm_yeni_siparis_bildirimi_metni'];
        } else {
            $this->data['netgsm_yeni_siparis_bildirimi_metni'] = $this->config->get('netgsm_yeni_siparis_bildirimi_metni');
        }
        if (isset($this->request->post['netgsm_yeni_siparis_bildirim_numaralari'])) {
            $this->data['netgsm_yeni_siparis_bildirim_numaralari'] = $this->request->post['netgsm_yeni_siparis_bildirim_numaralari'];
        } else {
            $this->data['netgsm_yeni_siparis_bildirim_numaralari'] = $this->config->get('netgsm_yeni_siparis_bildirim_numaralari');
        }
        if (isset($this->request->post['netgsm_yeni_siparis_bildirimi_musteri'])) {
            $this->data['netgsm_yeni_siparis_bildirimi_musteri'] = $this->request->post['netgsm_yeni_siparis_bildirimi_musteri'];
        } else {
            $this->data['netgsm_yeni_siparis_bildirimi_musteri'] = $this->config->get('netgsm_yeni_siparis_bildirimi_musteri');
        }
        if (isset($this->request->post['netgsm_yeni_siparis_bildirimi_musteri_metni'])) {
            $this->data['netgsm_yeni_siparis_bildirimi_musteri_metni'] = $this->request->post['netgsm_yeni_siparis_bildirimi_musteri_metni'];
        } else {
            $this->data['netgsm_yeni_siparis_bildirimi_musteri_metni'] = $this->config->get('netgsm_yeni_siparis_bildirimi_musteri_metni');
        }
        if (isset($this->request->post['netgsm_kargo_durumu'])) {
            $this->data['netgsm_kargo_durumu'] = $this->request->post['netgsm_kargo_durumu'];
        } else {
            $this->data['netgsm_kargo_durumu'] = $this->config->get('netgsm_kargo_durumu');
        }
        if (isset($this->request->post['netgsm_siparis_iptal_numaralari'])) {
            $this->data['netgsm_siparis_iptal_numaralari'] = $this->request->post['netgsm_siparis_iptal_numaralari'];
        } else {
            $this->data['netgsm_siparis_iptal_numaralari'] = $this->config->get('netgsm_siparis_iptal_numaralari');
        }
        if (isset($this->request->post['netgsm_siparis_iptal '])) {
            $this->data['netgsm_siparis_iptal'] = $this->request->post['netgsm_siparis_iptal'];
        } else {
            $this->data['netgsm_siparis_iptal'] = $this->config->get('netgsm_siparis_iptal');
        }
        if (isset($this->request->post['netgsm_siparis_iptal_metni'])) {
            $this->data['netgsm_siparis_iptal_metni'] = $this->request->post['netgsm_siparis_iptal_metni'];
        } else {
            $this->data['netgsm_siparis_iptal_metni'] = $this->config->get('netgsm_siparis_iptal_metni');
        }
        if (isset($this->request->post['netgsm_rehber_kayit'])) {
            $this->data['netgsm_rehber_kayit'] = $this->request->post['netgsm_rehber_kayit'];
        } else {
            $this->data['netgsm_rehber_kayit'] = $this->config->get('netgsm_rehber_kayit');
        }
        if (isset($this->request->post['netgsm_rehber_grupadi'])) {
            $this->data['netgsm_rehber_grupadi'] = $this->request->post['netgsm_rehber_grupadi'];
        } else {
            $this->data['netgsm_rehber_grupadi'] = $this->config->get('netgsm_rehber_grupadi');
        }

        if(empty($this->data['netgsm_usercode']) || empty($this->data['netgsm_password']) ){
            $this->data['netgsm_kredi'] = 'Sms göndermek ve bakiyenizi görüntüleyebilmek için üyelik bilgilerinizi giriniz.';
            $this->data['netgsm_paket'] = 'Paket ve Kampanyalarınızı görüntüleyebilmek için üyelik bilgilerinizi giriniz.';
            $this->data['netgsm_smsbaslik'] = '';
            $this->data['netgsm_tum_smsbasliklar'] = '';
        }else{
            $this->load->library('netgsmsms');
            $netgsmsms = new Netgsmsms($this->data['netgsm_usercode'],$this->data['netgsm_password']);
            $this->data['netgsm_kredi'] = $netgsmsms->getKredi();
            $this->data['netgsm_smsbaslik'] = $this->config->get('netgsm_smsbaslik');
            $this->data['netgsm_tum_smsbasliklar'] = $netgsmsms->getSmsBaslik();
            $this->data['netgsm_paket'] = $netgsmsms->getPaket();
        }

        $this->load->model('localisation/order_status');
        $kargo_durumlari = $this->model_localisation_order_status->getOrderStatuses();
        $this->data['kargo_durumlari'] = $kargo_durumlari;

        foreach ($kargo_durumlari as $kd){
            if (isset($this->request->post['netgsm_kargo_durumu_metni_'.$kd['order_status_id']])) {
                $this->data['netgsm_kargo_durumu_metni_'.$kd['order_status_id']] = $this->request->post['netgsm_kargo_durumu_metni_'.$kd['order_status_id']];
            } else {
                $this->data['netgsm_kargo_durumu_metni_'.$kd['order_status_id']] = $this->config->get('netgsm_kargo_durumu_metni_'.$kd['order_status_id']);
            }
        }

        $this->load->model('design/layout');
        $this->data['layouts'] = $this->model_design_layout->getLayouts();
        $this->template = 'module/netgsm.tpl';
        $this->children = array(
            'common/header',
            'common/footer'
        );
        $this->response->setOutput($this->render());

    }

    protected function validate()
    {
        if (!$this->user->hasPermission('modify', 'module/netgsm')) {
            $this->error['warning'] = 'Uyarı: Netgsm SMS modülünü değiştirme iznine sahip değilsiniz!';
        }

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    public function SMSgonder()
    {
        $json = array();
        if(isset($this->request->post['message'])){
            $this->load->library('netgsmsms');
            $netgsmsms = new Netgsmsms($this->config->get('netgsm_usercode'),$this->config->get('netgsm_password'));

            $cevap = $netgsmsms->bulkSMS($this->request->post['phone'],$this->request->post['message'],$this->config->get('netgsm_smsbaslik'));

            $bol = explode(' ',$cevap);
            if($bol[0]=='00')
            {
                $json['result'] = 'success';
                $json['resultmsg'] = 'Sms gönderimi başarılı.';
            }
            else{
                $json['result'] = 'error';
                $json['resultmsg'] = 'Sms gönderimi başarısız. Lütfen Netgsm hesabınıza giriş yaptığınıza ve başlık seçtiğinize emin olun.' ;
            }
        }
        else
        {
            $json['result'] = 'error';
            $json['resultmsg'] = 'Sms gönderimi başarısız.';
        }

        $this->response->setOutput(json_encode($json));
    }
}